IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_MOVIMENTO_VENDAS_RsVendasQtde')
BEGIN
	DROP TABLE EST_MOVIMENTO_VENDAS_RsVendasQtde
END
go
CREATE TABLE EST_MOVIMENTO_VENDAS_RsVendasQtde(CD_EMP						INT,
														CD_FILIAL           INT,
														CD_CTR_DT_MOVIMENTO INT,
														TIPO_VENDA          INT,
														QTDE_VENDAS         Money
														CONSTRAINT [PK_EST_MOVIMENTO_VENDAS_RsVendasQtde] 
															PRIMARY KEY CLUSTERED (CD_CTR_DT_MOVIMENTO, CD_FILIAL, TIPO_VENDA, CD_EMP));

go

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_MOVIMENTO_VENDAS_RsVendasItens')
BEGIN
	DROP TABLE EST_MOVIMENTO_VENDAS_RsVendasItens
END
go
CREATE TABLE EST_MOVIMENTO_VENDAS_RsVendasItens 
										   (CD_CTR			 BIGINT IDENTITY (1,1),
											CD_EMP              INT,
											CD_FILIAL           INT,
											CD_VD               INT,
											CD_PROD             INT,
											CD_CTR_DT_MOVIMENTO INT,
											TIPO_VENDA          INT,
											VLR_VD              MONEY,
											VLR_DESC_ITENS      MONEY,
											VLR_VD_LIQ          MONEY,
											QTDE_VENDAS         INT,
											QT_ITENS            MONEY,
											VLR_DESC_VERBA      MONEY,
											VLR_DESC_RATEIO     MONEY,
											VLR_PMC             MONEY,
											VLR_DESC_OFERTA     MONEY,
											VLR_CUSTO           MONEY,
											VLR_CUSTO_MEDIO     MONEY,
											VLR_CUSTO_GER       MONEY,
											VLR_ICMS            MONEY,
											VLR_PIS_COFINS      MONEY,
											QTDE_ITENS          MONEY,
											VLR_DINHEIRO        MONEY,
											VLR_CHEQUES         MONEY,
											VLR_CHEQUES_VISTA   MONEY,
											VLR_CHEQUES_PRAZO   MONEY,
											VLR_CARTAO          MONEY,
											VLR_TICKETS         MONEY,
											VLR_DUPLICATA       MONEY,
											VLR_CONV            MONEY,
											VLR_CHEQUE_TROCO    MONEY,
											VLR_NCC             MONEY,
											VLR_COMISSAO        MONEY,
											VLR_COMISSAO_FABRIC MONEY,
											CD_VEND             INT,
											CD_OPERADOR         INT,
											VLR_RECOMPOSICAO_MARGEM MONEY,
											VLR_CONV_PBM		MONEY,
											CD_ORIGEM_VENDA		MONEY,
											VLR_ISSQN			MONEY,
											CD_PARCEIRO 		  int,
											CPF_CLIENTE_PARCEIRO  varchar(55),
											NOME_CLIENTE_PARCEIRO varchar(255),
											TIPO_DESCONTO		  int ,
											DS_TIPO_DESCONTO	  varchar(100),
											
											
											CONSTRAINT [PK_EST_MOVIMENTO_VENDAS_RsVendasItens] 
															PRIMARY KEY CLUSTERED (CD_CTR_DT_MOVIMENTO, CD_FILIAL, CD_EMP, CD_CTR));
go
go
IF OBJECT_ID('P_EST_MOVIMENTO_VENDAS') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EST_MOVIMENTO_VENDAS;
END;
GO
--EXEC P_EST_MOVIMENTO_VENDAS 1,'2017-12-27'
/*
=======================================================================================
'Job.................: Linx - Manutencao de consolidacao movimentos vendas anteriores e Linx - Manutencao durante o dia
'Função..............: Executada pela P_EST_PROD_VD_PROC_ALL
'Objetivo............: Alterar codigo do produto 
'Tabelas.............: 
'Dt Modificação......: 14/06/2021
'Modificação.........: Tag #A001 - Devolução notas fiscais 
					   Tag #A002 - Notas Ficais adicionado a formula para gerar valor custo 
					   Tag #A003 - Formula do VLR_VD_LIQ
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
CREATE PROCEDURE [dbo].[P_EST_MOVIMENTO_VENDAS](@CD_EMP  INT,@DT_PROC DATETIME, @CD_FILIAL_PARAM INT =0, @PrintDebug tinyint=0)
AS
 
 
   	 SET NOCOUNT ON;	
     SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
/**********************************************************************************************************************************************/
     DECLARE @CD_CTR_DT_MOVIMENTO INT;
	print '=====================================================MOVIMENTO DE VENDAS ===================================================='
	PRINT 'Processando data: ' +CONVERT(CHAR(10), @DT_PROC, 103) + ' - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
    PRINT 'Processando Filial: '+CONVERT(VARCHAR(20), @CD_FILIAL_PARAM)

	SELECT
		@CD_CTR_DT_MOVIMENTO = CD_CTR_DT_MOVIMENTO
	FROM
		GLB_DT_MOVIMENTO
	WHERE DT_MOVIMENTO = @DT_PROC;


/**********************************************************************************************************************************************/ 
/**********************************************************************************************************************************************/         
/**********************************************************************************************************************************************/    
    
	DECLARE @cd_chave int ;
	DECLARE @SqlDel varchar(8000);
							
	declare c_Chave CURSOR FAST_FORWARD FOR
	select 
		distinct  m.CD_CTR_VENDAS
	FROM 
		EST_MOVIMENTO_VENDAS m
	WHERE 
		m.CD_CTR_DT_MOVIMENTO = @CD_CTR_DT_MOVIMENTO
		AND	m.CD_EMP = 1
		AND m.CD_FILIAL = @CD_FILIAL_PARAM ;
		 
	OPEN c_Chave
	FETCH NEXT FROM c_Chave INTO @cd_chave
	WHILE @@FETCH_STATUS = 0
		BEGIN
			if @PrintDebug > 0
			begin
				PRINT 'Procesando reg.: ' + CONVERT(VARCHAR, @cd_chave)			
				PRINT 'Deletando produtos do movimento anterior - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
			end

			set  @SqlDel= 'delete FROM  EST_MOVIMENTO_VENDAS_PRODUTOS WHERE  CD_CTR_VENDAS = ' + Convert (varchar(10), @cd_chave) + ' AND CD_EMP = 1;'
			exec (@SqlDel);
						
			---------------------------------------------------------------------------------------------
			if @PrintDebug > 0
			begin
				PRINT 'Deletando Tickets movimento anterior - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
			end

			set  @SqlDel= 'delete FROM  EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS WHERE  CD_CTR_VENDAS = ' + Convert (varchar(10), @cd_chave) + ' AND CD_EMP = 1 AND CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM) +';' 
			exec (@SqlDel);

			---------------------------------------------------------------------------------------------

			set  @SqlDel= 'delete FROM  EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_VENDEDOR WHERE  CD_CTR_VENDAS = ' + Convert (varchar(10), @cd_chave) + ' AND CD_EMP = 1 AND CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM) +';'  
			exec (@SqlDel);

			---------------------------------------------------------------------------------------------	
			
			set  @SqlDel= 'delete FROM  EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO 
									WHERE  CD_CTR_VENDAS = ' + Convert (varchar(10), @cd_chave) + ' AND CD_EMP = 1 AND CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM) +';' 
			exec (@SqlDel);

			---------------------------------------------------------------------------------------------	

			---------------------------------------------------------------------------------------------	 

			FETCH NEXT FROM c_Chave INTO @cd_chave
		END
	CLOSE c_Chave;
	DEALLOCATE c_Chave; 
	
	if @PrintDebug > 0
		PRINT 'Deletando o movimento anterior Ctr: '+ convert (varchar(20), @CD_CTR_DT_MOVIMENTO )+ ' - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);


	set @SqlDel = 'DELETE FROM EST_MOVIMENTO_VENDAS
					WHERE CD_CTR_DT_MOVIMENTO = '+ convert (varchar(20), @CD_CTR_DT_MOVIMENTO )+ '
					AND CD_EMP = 1 AND CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM) +';'

	exec (@SqlDel);
/**********************************************************************************************************************************************/
	set @SqlDel = 'DELETE FROM EST_MOVIMENTO_VENDAS_RsVendasItens
						WHERE CD_CTR_DT_MOVIMENTO = '+ convert (varchar(20), @CD_CTR_DT_MOVIMENTO )+ '
						AND CD_EMP = 1 AND CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM) +';'

	exec (@SqlDel);
	 
	set @SqlDel = 'DELETE FROM EST_MOVIMENTO_VENDAS_RsVendasQtde
						WHERE CD_CTR_DT_MOVIMENTO = '+ convert (varchar(20), @CD_CTR_DT_MOVIMENTO )+ '
						AND CD_EMP = 1 AND CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM) +';'

	exec (@SqlDel);
	 

/**********************************************************************************************************************************************/
	if @PrintDebug > 0
		PRINT 'Gerando a quantidade de vendas - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
   
/**********************************************************************************************************************************************/
--Vendas validas
     
    INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasQtde
    SELECT 
	   v.CD_EMP,
	   v.CD_FILIAL,
	   GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
	   0 AS TIPO_VENDA,
	   COUNT(v.CD_VD) AS QTDE_VENDA
    FROM 
	   PDV_VD AS V
	   INNER JOIN GLB_DT_MOVIMENTO ON V.DT_VD = GLB_DT_MOVIMENTO.DT_MOVIMENTO
    WHERE 
	   V.CD_EMP = @CD_EMP
	   AND V.DT_VD = @DT_PROC
	   AND V.ST_VD = 0
	   AND V.CD_FILIAL =@CD_FILIAL_PARAM
    GROUP BY 
	   v.CD_EMP,
	   v.CD_FILIAL,
	   GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO;

    

/**********************************************************************************************************************************************/
--Vendas canceladas

	if @PrintDebug > 0
		PRINT 'Vendas qtde canceladas - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

    INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasQtde
    SELECT 
	   v.CD_EMP,
	   v.CD_FILIAL,
	   GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
	   1 AS TIPO_VENDA,
	   COUNT(v.CD_VD) AS QTDE_VENDA
    FROM 
	   PDV_VD AS V
	   INNER JOIN GLB_DT_MOVIMENTO ON 
	   V.DT_VD = GLB_DT_MOVIMENTO.DT_MOVIMENTO
    WHERE 
	   V.CD_EMP = @CD_EMP
	   AND V.DT_VD = @DT_PROC
	   AND V.CD_FILIAL =@CD_FILIAL_PARAM
	   AND V.ST_VD = 1
    GROUP BY 
	   v.CD_EMP,
	   v.CD_FILIAL,
	   GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO;

/**********************************************************************************************************************************************/
if @PrintDebug > 0
     PRINT 'Vendas qtde cupons nao fiscais - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);    

/**********************************************************************************************************************************************/
     
--Vendas recarga
	INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasQtde
	SELECT
		   PDV_CUPOM_NAO_FISCAL.CD_EMP
		 , PDV_CUPOM_NAO_FISCAL.CD_FILIAL
		 , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		 , 2 AS TIPO_VENDA
		 , COUNT(CD_CTR) AS QTDE_VENDA
	FROM
		PDV_CUPOM_NAO_FISCAL
		INNER JOIN GLB_DT_MOVIMENTO ON PDV_CUPOM_NAO_FISCAL.DT_CUPOM = GLB_DT_MOVIMENTO.DT_MOVIMENTO
	WHERE  PDV_CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 3
		   AND PDV_CUPOM_NAO_FISCAL.CD_EMP = @CD_EMP
		   AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM = @DT_PROC
		   AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL =@CD_FILIAL_PARAM
		   AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
	GROUP BY
			 PDV_CUPOM_NAO_FISCAL.CD_EMP
		   , PDV_CUPOM_NAO_FISCAL.CD_FILIAL
		   , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO;
/**********************************************************************************************************************************************/
if @PrintDebug > 0
     PRINT 'Vendas qtde devolucoes - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
/**********************************************************************************************************************************************/
    
    --Vendas devolvidas 
	INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasQtde
	SELECT
		   PDV_VD_DEV_EST_PROD_IMP.CD_EMP
		 , PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
		 , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		 , 3 AS TIPO_VENDA
		 , COUNT(DISTINCT PDV_VD.CD_VD) AS QTDE_VENDA
	FROM
		PDV_VD_DEV_EST_PROD_IMP
		INNER JOIN PDV_VD ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD.CD_EMP
							 AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD.CD_FILIAL
							 AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD.CD_VD
		INNER JOIN GLB_DT_MOVIMENTO ON PDV_VD_DEV_EST_PROD_IMP.DT_DEVO = GLB_DT_MOVIMENTO.DT_MOVIMENTO
	WHERE  
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP = @CD_EMP
		AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO = @DT_PROC
		AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL =@CD_FILIAL_PARAM
	GROUP BY
			 PDV_VD_DEV_EST_PROD_IMP.CD_EMP
		   , PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
		   , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO;

/**********************************************************************************************************************************************/
if @PrintDebug > 0
     PRINT 'Vendas qtde notas fiscais - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
/**********************************************************************************************************************************************/
     
    --Vendas nota fiscal 
	INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasQtde
	SELECT
		   EST_NF_SAI.CD_EMP
		 , EST_NF_SAI.CD_FILIAL
		 , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		 , 10 AS TIPO_VENDA
		 , COUNT(EST_NF_SAI.CD_NF) AS QTDE_VENDA
	FROM
		EST_NF_SAI
		INNER JOIN GLB_DT_MOVIMENTO ON EST_NF_SAI.DT_EMI_NF = GLB_DT_MOVIMENTO.DT_MOVIMENTO
		INNER JOIN EST_NF_SAI_VENDAS ON EST_NF_SAI.CD_EMP = EST_NF_SAI_VENDAS.CD_EMP
										AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_VENDAS.CD_FILIAL
										AND EST_NF_SAI.CD_NF = EST_NF_SAI_VENDAS.CD_NF
	WHERE  EST_NF_SAI.CD_EMP = @CD_EMP
		   AND EST_NF_SAI.DT_EMI_NF = @DT_PROC
		   AND EST_NF_SAI.STS_NF = 0
		   AND EST_NF_SAI.CD_FILIAL =@CD_FILIAL_PARAM
	GROUP BY
			 EST_NF_SAI.CD_EMP
		   , EST_NF_SAI.CD_FILIAL
		   , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO;

/**********************************************************************************************************************************************/
if @PrintDebug > 0
     PRINT 'devolucao qtde notas fiscais vendas  - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
/**********************************************************************************************************************************************/
    
    --Vendas devolvidas nota fiscal 
	INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasQtde
	SELECT
		   V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
		 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL
		 , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		 , 11 AS TIPO_VENDA
		 , COUNT(DISTINCT V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_NF) AS QTDE_VENDA
	FROM
		V_EST_NF_SAI_VENDAS_DEVOLUCAO
		INNER JOIN GLB_DT_MOVIMENTO ON V_EST_NF_SAI_VENDAS_DEVOLUCAO.DT_DEVO = GLB_DT_MOVIMENTO.DT_MOVIMENTO
	WHERE  
		V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP = @CD_EMP
		AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.DT_DEVO = @DT_PROC
		AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL =@CD_FILIAL_PARAM
	GROUP BY
			 V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
		   , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL
		   , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO;
	  
/**********************************************************************************************************************************************/
if @PrintDebug > 0
     PRINT 'Analisando vendas por produto - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
 
/**********************************************************************************************************************************************/
    DECLARE @CD_FILIAL int 
    DECLARE cLojsFl CURSOR FAST_FORWARD READ_ONLY FOR
    SELECT 
	   CD_FILIAL
    FROM 
	   PRC_FILIAL 
	WHERE CD_FILIAL =@CD_FILIAL_PARAM
	AND CD_EMP =1

    OPEN cLojsFl
    FETCH NEXT FROM cLojsFl INTO @CD_FILIAL

    WHILE @@FETCH_STATUS = 0
    begin
    
		--Vendas cupom fiscal
		if @PrintDebug > 0
			PRINT 'Vendas cupons fiscais Loja.: ' + CONVERT(VARCHAR, @CD_FILIAL ) + ' - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
--Tag #A003
		INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasItens
		   (CD_EMP,      CD_FILIAL,      CD_VD,      CD_PROD,      CD_CTR_DT_MOVIMENTO,      TIPO_VENDA,
				VLR_VD,      VLR_DESC_ITENS,      VLR_VD_LIQ,      QTDE_VENDAS,      QT_ITENS,      VLR_DESC_VERBA,
				VLR_DESC_RATEIO,      VLR_PMC,      VLR_DESC_OFERTA,      VLR_CUSTO,      VLR_CUSTO_MEDIO,      VLR_CUSTO_GER,
				VLR_ICMS,      VLR_PIS_COFINS,      QTDE_ITENS,      VLR_DINHEIRO,      VLR_CHEQUES,      VLR_CHEQUES_VISTA,      VLR_CHEQUES_PRAZO,
				VLR_CARTAO,      VLR_TICKETS,      VLR_DUPLICATA,      VLR_CONV,      VLR_CHEQUE_TROCO,      VLR_NCC,
				VLR_COMISSAO,      VLR_COMISSAO_FABRIC,      CD_VEND,      CD_OPERADOR,VLR_RECOMPOSICAO_MARGEM, VLR_CONV_PBM,CD_ORIGEM_VENDA,VLR_ISSQN
				, CD_PARCEIRO,CPF_CLIENTE_PARCEIRO,NOME_CLIENTE_PARCEIRO,TIPO_DESCONTO,DS_TIPO_DESCONTO)
            
		SELECT
			   i.CD_EMP
			 , i.CD_FILIAL
			 , i.CD_VD
			 , i.CD_PROD
			 , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
			 , 0 AS TIPO_VENDA
			 , ((I.QT_IT * I.VLR_IT)) AS VLR_VD
			 , ((((I.QT_IT * I.VLR_IT) * I.TX_DESC) / 100) - (ISNULL(I.VLR_DESC_VERBA, 0))) AS VLR_DESC_ITENS
			, CASE WHEN ISNULL(CASE WHEN I.VLR_DESC IS NULL  OR I.VLR_DESC = 0 THEN (I.TOT_IT - ISNULL(I.VLR_DESC_TOT_RAT, 0))
				ELSE
			(ISNULL((CASE
							   WHEN ISNULL(I.TP_PROD, 0) IN(10, 11) THEN ISNULL(I.TOT_IT, 0)
							   ELSE ISNULL(I.VLR_PMC, 0) * I.QT_IT
						   END), 0)) /* VLR_PMC*/ -
						   --((((I.QT_IT * I.VLR_IT) * I.TX_DESC) / 100) - (ISNULL(I.VLR_DESC_VERBA, 0))) /*VLR_DESC_ITENS */ - 
						   ISNULL(I.VLR_DESC , ((((I.QT_IT * I.VLR_IT) * I.TX_DESC) / 100) - (ISNULL(I.VLR_DESC_VERBA, 0)))) /*VLR_DESC_ITENS */ - 
						   (((ISNULL((CASE
							   WHEN ISNULL(I.TP_PROD, 0) IN(10, 11) THEN ISNULL(I.TOT_IT, 0)
							   ELSE (ISNULL(I.VLR_PMC, 0)  * I.QT_IT)
						   END), 0)) 	    - (I.VLR_IT * I.QT_IT)) ) /* VLR_DESC_OFERTA */-
						   (I.VLR_DESC_TOT_RAT)
				END,0)  <> ( I.TOT_IT - ISNULL(I.VLR_DESC_TOT_RAT, 0) )  THEN (I.TOT_IT - ISNULL(I.VLR_DESC_TOT_RAT, 0))  
				ELSE 
					 ISNULL(CASE WHEN I.VLR_DESC IS NULL  OR I.VLR_DESC = 0 THEN (I.TOT_IT - ISNULL(I.VLR_DESC_TOT_RAT, 0))
								 ELSE (ISNULL((CASE WHEN ISNULL(I.TP_PROD, 0) IN(10, 11) THEN ISNULL(I.TOT_IT, 0)
													ELSE ISNULL(I.VLR_PMC, 0) * I.QT_IT
												END), 0)) /* VLR_PMC*/ -
												--((((I.QT_IT * I.VLR_IT) * I.TX_DESC) / 100) - (ISNULL(I.VLR_DESC_VERBA, 0))) /*VLR_DESC_ITENS */ - 
									  ISNULL(I.VLR_DESC , ((((I.QT_IT * I.VLR_IT) * I.TX_DESC) / 100) - (ISNULL(I.VLR_DESC_VERBA, 0)))) /*VLR_DESC_ITENS */ - 
											(((ISNULL((CASE WHEN ISNULL(I.TP_PROD, 0) IN(10, 11) THEN ISNULL(I.TOT_IT, 0)
														    ELSE (ISNULL(I.VLR_PMC, 0)  * I.QT_IT)
														END), 0)) 	    - (I.VLR_IT * I.QT_IT)) ) /* VLR_DESC_OFERTA */-
														(I.VLR_DESC_TOT_RAT)
							END,0) 
				END AS VLR_VD_LIQ
			 --, (I.TOT_IT - ISNULL(I.VLR_DESC_TOT_RAT, 0)) AS VLR_VD_LIQ
			 , 0 AS QTDE_VENDAS
			 , (I.QT_IT) AS QT_IT
			 , (ISNULL(I.VLR_DESC_VERBA, 0)) AS VLR_DESC_VERBA
			 , (I.VLR_DESC_TOT_RAT)
			 , (ISNULL((CASE
							   WHEN ISNULL(i.TP_PROD, 0) IN(10, 11) THEN ISNULL(I.TOT_IT, 0)
							   ELSE ISNULL(I.VLR_PMC, 0) * I.QT_IT
						   END), 0)) AS VLR_PMC
			 , ((I.VLR_PMC - I.VLR_IT) * I.QT_IT) AS VLR_DESC_OFERTA
			 , (CASE
					   WHEN i.TP_PROD IN(10, 11) THEN I.TOT_IT - (I.TOT_IT * (ISNULL(i.PERC_COMISSAO_SERVICO, 0) / 100))
					   ELSE ISNULL(I.VLR_CUSTO, 0) * I.QT_IT
				   END) AS VLR_CUSTO
			 , (CASE
				   WHEN i.TP_PROD IN(10, 11) THEN I.TOT_IT - (I.TOT_IT * (ISNULL(i.PERC_COMISSAO_SERVICO, 0) / 100))
				   ELSE ISNULL(I.VLR_CUSTO_MEDIO, 0) * I.QT_IT
				 END) AS VLR_CUSTO_MEDIO
			 , (CASE
					   WHEN i.TP_PROD IN(10, 11) THEN I.TOT_IT - (I.TOT_IT * (ISNULL(i.PERC_COMISSAO_SERVICO, 0) / 100))
					   ELSE ISNULL(I.VLR_CUSTO_GER, 0) * I.QT_IT
				   END) AS VLR_CUSTO_GER
			 , (CASE
					   WHEN I.QT_IT > 0 THEN CASE
												 WHEN I.TP_PROD IN(10, 11) THEN 0
												 ELSE(((I.TOT_IT)) * CASE
																		 WHEN I.TX_RED_IT > 0 THEN((I.TX_ICMS_IT * I.TX_RED_IT) / 100.0000)
																		 ELSE I.TX_ICMS_IT
																	 END) / 100.0000
											 END
					   ELSE 0
				   END) AS VLR_IMPOSTOS
			 , (ROUND(I.VLR_PIS,2) + ROUND(I.VLR_COFINS,2))
			 , (I.QT_IT) AS QTDE_ITENS
			 , (CASE
					   WHEN V.VLR_DINH = 0 THEN 0
					   ELSE CASE
								WHEN V.VLR_LIQ_VD > 0 THEN CASE
															   WHEN V.VLR_LIQ_VD = V.VLR_DINH THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
															   ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_DINH AS NUMERIC(18, 4))) AS NUMERIC(18, 4))
														   END
								ELSE 0
							END
				   END) AS VLR_DINH_IT
			 ,  (CASE
					   WHEN V.VLR_CHQS = 0 THEN 0
					   ELSE CASE
								WHEN V.VLR_LIQ_VD > 0 THEN CASE
															   WHEN V.VLR_LIQ_VD = V.VLR_CHQS THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
															   ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_CHQS AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
														   END
								ELSE 0
							END
				   END) AS VLR_CHQS_IT
			 ,  (ISNULL((CASE
							   WHEN V.VL_CHQS_A_VISTA > 0 THEN CASE
																   WHEN V.VLR_LIQ_VD > 0 THEN(CASE
																								  WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
																								  ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VL_CHQS_A_VISTA AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
																							  END)
																   ELSE 0
															   END
							   ELSE 0
						   END), 0)) AS VLR_CHQS_IT_VISTA
			 ,  (ISNULL((CASE
							   WHEN V.VL_CHQS_A_PRZ > 0 THEN CASE
																 WHEN V.VLR_LIQ_VD > 0 THEN(CASE
																								WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
																								ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VL_CHQS_A_PRZ AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
																							END)
																 ELSE 0
															 END
							   ELSE 0
						   END), 0)) AS VLR_CHQS_IT_PRAZO
			 ,  (ISNULL((CASE
							   WHEN V.VLR_CARTAO > 0 THEN CASE
															  WHEN V.VLR_LIQ_VD > 0 THEN(CASE
																							 WHEN V.VLR_LIQ_VD = V.VLR_CARTAO THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
																							 ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_CARTAO AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
																						 END)
															  ELSE 0
														  END
							   ELSE 0
						   END), 0)) AS VLR_CARTAO_IT
			 ,  ((CASE
						WHEN V.VLR_TICKETS > 0 THEN CASE
														WHEN V.VLR_LIQ_VD > 0 THEN CASE
																					   WHEN V.VLR_LIQ_VD = V.VLR_TICKETS THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
																					   ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_TICKETS AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
																				   END
														ELSE 0
													END
						ELSE 0
					END)) AS VLR_TICKETS_IT
			 ,  ((CASE
						WHEN V.VLR_DUP > 0 THEN CASE
													WHEN V.VLR_LIQ_VD > 0 THEN CASE
																				   WHEN V.VLR_LIQ_VD = V.VLR_DUP THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
																				   ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_DUP AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
																			   END
													ELSE 0
												END
						ELSE 0
					END)) AS VLR_DUP_IT
			 ,  ((CASE
						WHEN V.VLR_CONV > 0 THEN CASE
													 WHEN V.VLR_LIQ_VD > 0 THEN CASE
																					WHEN V.VLR_LIQ_VD = V.VLR_CONV THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
																					ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_CONV AS NUMERIC(18, 4))) AS NUMERIC(18, 4))
																				END
													 ELSE 0
												 END
						ELSE 0
					END)) AS VLR_CONV_IT
			 ,  ((CASE
						WHEN V.VLR_TROCO_CHQ > 0 THEN CASE
														  WHEN V.VLR_LIQ_VD > 0 THEN CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_TROCO_CHQ AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
														  ELSE 0
													  END
						ELSE 0
					END)) AS VLR_TROCO_CHQ_IT
			 ,  (ISNULL((CASE
							   WHEN V.VLR_NCC > 0 THEN CASE
														   WHEN V.VLR_LIQ_VD > 0 THEN(CASE
																						  WHEN V.VLR_LIQ_VD = ISNULL(V.VLR_NCC, 0) THEN CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
																						  ELSE CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(ISNULL(V.VLR_NCC, 0) AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
																					  END)
														   ELSE 0
													   END
						   END), 0)) AS VLR_NCC_IT
			 ,  (((I.TOT_IT - I.VLR_DESC_TOT_RAT) * I.PERC_COMIS) / 100) AS VLR_COMISSAO
			 ,  (ISNULL(i.VLR_COMISSAO_FABRIC, 0)) AS VLR_COMISSAO_FABRIC
			 , isnull(I.CD_VEND, 0) CD_VEND
			 , V.CD_USU
			 ,  (ISNULL(I.VLR_RECOMPOSICAO_MARGEM, 0)) AS VLR_RECOMPOSICAO_MARGEM
			 ,  (ISNULL(PDV_VD_IT_VD_PBM.VLR_REEMBOL, 0) + ISNULL(PDV_VD_IT_VD_PBM.VLR_CONVENIO, 0)) AS VLR_CONV_PBM
			 , CASE
				   WHEN TELE_ORC_ETAPA_PDV_VD.CD_VD IS NULL THEN CASE
																	 WHEN TLV_PED_VD_PDV_VD.CD_VD IS NULL THEN CASE
																												   WHEN V.NR_ORC = 0 THEN 0 --DIRETO P.D.V  
																												   ELSE CASE
																															WHEN isnull(V.ORIG_ORC, 0) = 0 THEN 1 --ORCAMENTO
																															WHEN V.ORIG_ORC = 1 THEN 2 --TELEVENDAS  
																															WHEN V.ORIG_ORC = 2 THEN 3 --PBM  
																															WHEN V.ORIG_ORC = 3 THEN 4 --DRIVE THRU  
																															ELSE 1
																														END
																											   END
																	 ELSE 2 --TELEVENDAS  
																 END
				   ELSE 2 --TELEVENDAS  
			   END AS ORIG_VENDA
			 ,  (CASE
					   WHEN I.QT_IT > 0 THEN CASE
												 WHEN I.TP_PROD IN(10, 11) THEN(((I.TOT_IT - I.VLR_DESC_TOT_RAT) / I.QT_IT) * I.TX_ICMS_IT) / 100.0000
												 ELSE 0
											 END
					   ELSE 0
				   END) AS VLR_ISSQN
			,ISNULL(V.CD_PARCEIRO,0) 		     
			,ISNULL(V.CPF_CLIENTE_PARCEIRO,'') 
			,ISNULL(V.NOME_CLIENTE_PARCEIRO,'')
			,ISNULL(I.TIPO_DESCONTO,0)
			,GLB_TP_DESCONTO.DS_TP_DESCONTO
		FROM
			PDV_VD AS V
			INNER JOIN PDV_VD_IT AS I ON V.CD_EMP = I.CD_EMP
										 AND V.CD_FILIAL = I.CD_FILIAL
										 AND V.CD_VD = I.CD_VD
										 AND V.DT_VD = I.DT_VD
			INNER JOIN GLB_DT_MOVIMENTO ON i.DT_VD = GLB_DT_MOVIMENTO.DT_MOVIMENTO
			LEFT OUTER JOIN PDV_VD_IT_VD_PBM ON i.CD_EMP = PDV_VD_IT_VD_PBM.CD_EMP
												AND i.CD_FILIAL = PDV_VD_IT_VD_PBM.CD_FILIAL
												AND i.CD_VD = PDV_VD_IT_VD_PBM.CD_VD
												AND i.CD_IT = PDV_VD_IT_VD_PBM.CD_IT
			LEFT OUTER JOIN TELE_ORC_ETAPA_PDV_VD ON V.CD_VD = TELE_ORC_ETAPA_PDV_VD.CD_VD
													 AND V.CD_FILIAL = TELE_ORC_ETAPA_PDV_VD.CD_FILIAL
													 AND V.CD_EMP = TELE_ORC_ETAPA_PDV_VD.CD_EMP
			LEFT OUTER JOIN TLV_PED_VD_PDV_VD ON V.CD_VD = TLV_PED_VD_PDV_VD.CD_VD
												 AND V.CD_FILIAL = TLV_PED_VD_PDV_VD.CD_FILIAL_PDV_VD
												 AND V.CD_EMP = TLV_PED_VD_PDV_VD.CD_EMP
		    LEFT OUTER JOIN GLB_TP_DESCONTO GLB_TP_DESCONTO ON i .TIPO_DESCONTO = GLB_TP_DESCONTO.CD_TP_DESCONTO												 
            WHERE 
				i.CD_EMP = 1
				AND i.DT_VD = @DT_PROC
				AND V.ST_VD = 0
				AND I.CD_FILIAL =@CD_FILIAL
				AND I.ST_IT = 1  

/**********************************************************************************************************************************************/
		if @PrintDebug > 0
			PRINT 'Vendas canceladas - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

/**********************************************************************************************************************************************/
		--Vendas canceladas
	   INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasItens
	    (CD_EMP,      CD_FILIAL,      CD_VD,      CD_PROD,      CD_CTR_DT_MOVIMENTO,      TIPO_VENDA,      VLR_VD,
			VLR_DESC_ITENS,      VLR_VD_LIQ,      QTDE_VENDAS,      QT_ITENS,      VLR_DESC_VERBA,      VLR_DESC_RATEIO,
			VLR_PMC,      VLR_DESC_OFERTA,      VLR_CUSTO,      VLR_CUSTO_MEDIO,      VLR_CUSTO_GER,      VLR_ICMS,      VLR_PIS_COFINS,      QTDE_ITENS,
			VLR_DINHEIRO,      VLR_CHEQUES,      VLR_CHEQUES_VISTA,      VLR_CHEQUES_PRAZO,      VLR_CARTAO,      VLR_TICKETS,     VLR_DUPLICATA,
			VLR_CONV,     VLR_CHEQUE_TROCO,      VLR_NCC,VLR_COMISSAO, VLR_COMISSAO_FABRIC, CD_VEND, CD_OPERADOR,VLR_RECOMPOSICAO_MARGEM, 
			VLR_CONV_PBM, CD_ORIGEM_VENDA,VLR_ISSQN, CD_PARCEIRO,CPF_CLIENTE_PARCEIRO,NOME_CLIENTE_PARCEIRO,TIPO_DESCONTO,DS_TIPO_DESCONTO)
        SELECT i.CD_EMP,
                i.CD_FILIAL,
                i.CD_VD,
                i.CD_PROD,
                GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
                1 AS TIPO_VENDA,
                (I.QT_IT * I.VLR_IT) AS VLR_VD,
                ((I.QT_IT * I.VLR_IT) * I.TX_DESC) / 100 - ISNULL(I.VLR_DESC_VERBA, 0) AS VLR_DESC_ITENS,
                CASE
                    WHEN(I.TOT_IT - I.VLR_DESC_TOT_RAT) > 0
                    THEN I.TOT_IT - I.VLR_DESC_TOT_RAT
                    ELSE 0
                END AS VLR_VD_LIQ,
                0 AS QTDE_VENDA,
                I.QT_IT AS QT_IT,
                ISNULL(I.VLR_DESC_VERBA, 0) AS VLR_DESC_VERBA,
                I.VLR_DESC_TOT_RAT,
                CASE
                    WHEN I.TP_PROD IN(10, 11)
                    THEN I.TOT_IT
                    ELSE ISNULL(I.VLR_PMC, 0) * I.QT_IT
                END AS VLR_PMC,
                ((I.VLR_PMC - I.VLR_IT) * I.QT_IT) AS VLR_DESC_OFERTA,
                CASE
                    WHEN i.TP_PROD IN(10, 11)
                    THEN I.TOT_IT - (I.TOT_IT * (ISNULL(i.PERC_COMISSAO_SERVICO,0) / 100))
                    ELSE ISNULL(I.VLR_CUSTO, 0) * I.QT_IT
                END AS VLR_CUSTO,
                CASE
                    WHEN i.TP_PROD IN(10, 11)
                    THEN I.TOT_IT - (I.TOT_IT * (ISNULL(i.PERC_COMISSAO_SERVICO,0) / 100))
                    ELSE ISNULL(I.VLR_CUSTO_MEDIO, 0) * I.QT_IT
                END AS VLR_CUSTO_MEDIO,
                CASE
                    WHEN i.TP_PROD IN(10, 11)
                    THEN I.TOT_IT - (I.TOT_IT * (ISNULL(i.PERC_COMISSAO_SERVICO,0) / 100))
                    ELSE ISNULL(I.VLR_CUSTO_GER, 0) * I.QT_IT
                END AS VLR_CUSTO_GER,
                0,
                0,
                I.QT_IT,
                   (CASE WHEN V.VLR_DINH = 0 THEN 
							0
					ELSE 
						CASE WHEN V.VLR_LIQ_VD > 0 THEN 
							CASE WHEN V.VLR_LIQ_VD = V.VLR_DINH THEN 
								CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
                            ELSE 
								CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_DINH AS NUMERIC(18, 4))) AS NUMERIC(18, 4))
                            END
                        ELSE 
							0
                        END
                    END) AS VLR_DINH_IT,
                   (CASE WHEN V.VLR_CHQS=0 THEN
						0
					ELSE
						CASE WHEN V.VLR_LIQ_VD > 0 THEN 
							CASE WHEN V.VLR_LIQ_VD = V.VLR_CHQS THEN 
								CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
							ELSE 
								CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_CHQS AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
							END
						ELSE
							0
						END
					END) AS VLR_CHQS_IT,
                   ISNULL((CASE WHEN V.VL_CHQS_A_VISTA > 0 THEN
								CASE WHEN V.VLR_LIQ_VD > 0 THEN 
									(CASE WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN 
										CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
									ELSE 
										CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VL_CHQS_A_VISTA AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
									END)
								ELSE
									0
								END
							ELSE
								0
                            END), 0) AS VLR_CHQS_IT_VISTA,
                   ISNULL((CASE WHEN V.VL_CHQS_A_PRZ > 0 THEN
								CASE WHEN V.VLR_LIQ_VD > 0 THEN 
									(CASE WHEN V.VLR_LIQ_VD = V.VL_CHQS_A_VISTA THEN 
											CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
									  ELSE 
										CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VL_CHQS_A_PRZ AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
									  END)
								ELSE
									0
								END
							ELSE
								0
                            END), 0) AS VLR_CHQS_IT_PRAZO,
                   ISNULL((CASE WHEN V.VLR_CARTAO > 0 THEN
								CASE WHEN V.VLR_LIQ_VD > 0 THEN 
									(CASE WHEN V.VLR_LIQ_VD = V.VLR_CARTAO THEN 
											CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
									  ELSE 
											CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_CARTAO AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
									   END)
								ELSE
									0
								END
						   ELSE
								0
						   END), 0) AS VLR_CARTAO_IT,
                   (CASE WHEN V.VLR_TICKETS > 0 THEN
						CASE WHEN V.VLR_LIQ_VD > 0 THEN 
							CASE WHEN V.VLR_LIQ_VD = V.VLR_TICKETS THEN 
									CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
							ELSE 
									CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_TICKETS AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
							END
						ELSE
							0
						END
					ELSE
						0
					END) AS VLR_TICKETS_IT,
                   (CASE WHEN V.VLR_DUP > 0 THEN
						CASE WHEN V.VLR_LIQ_VD > 0 THEN 
							CASE WHEN V.VLR_LIQ_VD = V.VLR_DUP THEN 
									CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
							  ELSE 
									CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_DUP AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
							  END
						ELSE
							0
						END
					ELSE
						0
					END) AS VLR_DUP_IT,
                   (CASE WHEN V.VLR_CONV > 0 THEN
						CASE WHEN V.VLR_LIQ_VD > 0 THEN 
							CASE WHEN V.VLR_LIQ_VD = V.VLR_CONV THEN 
								CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
							ELSE 
								CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_CONV AS NUMERIC(18, 4))) AS NUMERIC(18, 4))
							END
						ELSE
							0
						END
					ELSE
						0
					END) AS VLR_CONV_IT,
                   (CASE WHEN V.VLR_TROCO_CHQ > 0 THEN 
						CASE WHEN V.VLR_LIQ_VD > 0 THEN 
							CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(V.VLR_TROCO_CHQ AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
						ELSE
							0
						END
					ELSE
						0
					END) AS VLR_TROCO_CHQ_IT,
                   ISNULL((CASE WHEN V.VLR_NCC > 0 THEN
								CASE WHEN V.VLR_LIQ_VD > 0 THEN 
									(CASE WHEN V.VLR_LIQ_VD = ISNULL(V.VLR_NCC, 0) THEN 
											CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(18, 2))
									 ELSE 
										CAST(((CAST((I.TOT_IT - I.VLR_DESC_TOT_RAT) AS NUMERIC(20, 10)) / CAST(V.VLR_LIQ_VD AS NUMERIC(20, 10))) * CAST(ISNULL(V.VLR_NCC, 0) AS NUMERIC(18, 2))) AS NUMERIC(18, 2))
									 END)
								ELSE
									0
								END
                           END), 0) AS VLR_NCC_IT,
                ((I.TOT_IT * I.PERC_COMIS) / 100) AS VLR_COMISSAO,
                ISNULL(i.VLR_COMISSAO_FABRIC, 0) AS VLR_COMISSAO_FABRIC,
                I.CD_VEND,
                V.CD_USU,
				ISNULL(I.VLR_RECOMPOSICAO_MARGEM,0) AS VLR_RECOMPOSICAO_MARGEM,
				ISNULL(PDV_VD_IT_VD_PBM.VLR_REEMBOL,0)+ISNULL(PDV_VD_IT_VD_PBM.VLR_CONVENIO,0) AS VLR_CONV_PBM,
				   CASE WHEN TELE_ORC_ETAPA_PDV_VD.CD_VD IS NULL THEN   
						CASE WHEN TLV_PED_VD_PDV_VD.CD_VD IS NULL THEN   
							CASE WHEN V.NR_ORC = 0 THEN   
								0 --DIRETO P.D.V  
							ELSE  
								CASE WHEN isnull(V.ORIG_ORC,0) =0 THEN   
									1 --ORCAMENTO
								WHEN V.ORIG_ORC =1 THEN   
									2 --TELEVENDAS  
								WHEN V.ORIG_ORC =2 THEN   
									3 --PBM  
								WHEN V.ORIG_ORC =3 THEN   
									4 --DRIVE THRU  
								ELSE 1
								END		 
							END  
						ELSE   
							2 --TELEVENDAS  
						END   
				  ELSE   
						2 --TELEVENDAS  
				  END AS ORIG_VENDA,
				  0 AS VLR_ISSQN
			,ISNULL(V.CD_PARCEIRO,0) 		     
			,ISNULL(V.CPF_CLIENTE_PARCEIRO,'') 
			,ISNULL(V.NOME_CLIENTE_PARCEIRO,'')
			,ISNULL(I.TIPO_DESCONTO,0)
			,GLB_TP_DESCONTO.DS_TP_DESCONTO
        FROM 
			PDV_VD AS V
			INNER JOIN PDV_VD_IT AS I ON V.CD_EMP = I.CD_EMP
			AND V.CD_FILIAL = I.CD_FILIAL
			AND V.CD_VD = I.CD_VD
			AND V.DT_VD = I.DT_VD
			INNER JOIN GLB_DT_MOVIMENTO ON 
			i.DT_VD = GLB_DT_MOVIMENTO.DT_MOVIMENTO
			LEFT OUTER JOIN PDV_VD_IT_VD_PBM ON 
			i.CD_EMP = PDV_VD_IT_VD_PBM.CD_EMP AND
			i.CD_FILIAL = PDV_VD_IT_VD_PBM.CD_FILIAL AND
			i.CD_VD = PDV_VD_IT_VD_PBM.CD_VD AND 
			i.CD_IT = PDV_VD_IT_VD_PBM.CD_IT 
			LEFT OUTER JOIN TELE_ORC_ETAPA_PDV_VD ON   
			V.CD_VD                 = TELE_ORC_ETAPA_PDV_VD.CD_VD AND  
			V.CD_FILIAL             = TELE_ORC_ETAPA_PDV_VD.CD_FILIAL AND  
			V.CD_EMP                = TELE_ORC_ETAPA_PDV_VD.CD_EMP    
			LEFT OUTER JOIN TLV_PED_VD_PDV_VD ON   
			V.CD_VD         = TLV_PED_VD_PDV_VD.CD_VD AND  
			V.CD_FILIAL = TLV_PED_VD_PDV_VD.CD_FILIAL_PDV_VD AND  
			V.CD_EMP        = TLV_PED_VD_PDV_VD.CD_EMP  
			LEFT OUTER JOIN GLB_TP_DESCONTO GLB_TP_DESCONTO ON i .TIPO_DESCONTO = GLB_TP_DESCONTO.CD_TP_DESCONTO	            
		WHERE 
			i.CD_EMP = 1
			AND i.DT_VD = @DT_PROC
			AND I.CD_FILIAL =@CD_FILIAL
			AND v.ST_VD = 1;


/**********************************************************************************************************************************************/
	if @PrintDebug > 0
		PRINT 'Vendas de recarga - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

/**********************************************************************************************************************************************/
    --Vendas recarga     
	INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasItens (CD_EMP,      CD_FILIAL,      CD_VD,      CD_PROD,      CD_CTR_DT_MOVIMENTO,      TIPO_VENDA,      VLR_VD,      VLR_DESC_ITENS,
							 VLR_VD_LIQ,      QTDE_VENDAS,      QT_ITENS,      VLR_DESC_VERBA,      VLR_DESC_RATEIO,      VLR_PMC,      VLR_DESC_OFERTA,
					VLR_CUSTO,      VLR_CUSTO_MEDIO,      VLR_CUSTO_GER,      VLR_ICMS,      VLR_PIS_COFINS,      QTDE_ITENS,      VLR_DINHEIRO,      VLR_CHEQUES,
					VLR_CHEQUES_VISTA,      VLR_CHEQUES_PRAZO,      VLR_CARTAO,      VLR_TICKETS,      VLR_DUPLICATA,      VLR_CONV,      VLR_CHEQUE_TROCO,      VLR_NCC,
					VLR_COMISSAO,      VLR_COMISSAO_FABRIC,      CD_VEND,      CD_OPERADOR,VLR_RECOMPOSICAO_MARGEM, VLR_CONV_PBM,
					CD_ORIGEM_VENDA,VLR_ISSQN, CD_PARCEIRO,CPF_CLIENTE_PARCEIRO,NOME_CLIENTE_PARCEIRO,TIPO_DESCONTO,DS_TIPO_DESCONTO)

    SELECT PDV_CUPOM_NAO_FISCAL.CD_EMP,
            PDV_CUPOM_NAO_FISCAL.CD_FILIAL,
            PDV_CUPOM_NAO_FISCAL.CD_CTR,
            0 AS CD_PROD,
            GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
            2 AS TIPO_VENDA,
            PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM,
            0 AS VLR_DESC_ITENS,
            VLR_TOT_CUPOM AS VLR_VD_LIQ,
            0 AS QTDE_VENDA,
            1 AS QT_ITENS,
            0 AS VLR_DESC_VERBA,
            0 AS VLR_DESC_RATEIO,
            PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM AS VLR_PMC,
            0 AS VLR_DESC_OFERTA,
            PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM - (PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM * ISNULL(GLB_OPER_CEL.PERC_COMIS, 0)) / 100 AS VLR_CUSTO,
            PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM - (PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM * ISNULL(GLB_OPER_CEL.PERC_COMIS, 0)) / 100 AS VLR_CUSTO_MEDIO,
            PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM - (PDV_CUPOM_NAO_FISCAL.VLR_TOT_CUPOM * ISNULL(GLB_OPER_CEL.PERC_COMIS, 0)) / 100 AS VLR_CUSTO_GER,
            0,
            0,
            1 AS QT_IT,
            VLR_DINH AS VLR_DINHEIRO,
            VLR_CHQS AS VLR_CHEQUES,
            VLR_CHQS_A_VISTA AS VLR_CHEQUES_VISTA,
            VLR_CHQS_A_PRZ AS VLR_CHEQUES_PRAZO,
            VLR_CARTAO AS VLR_CARTAO,
            0 AS VLR_TICKETS,
            0 AS VLR_DUPLICATA,
            0 AS VLR_CONV,
            0 AS VLR_CHEQUE_TROCO,
            0 AS VLR_NCC,
            0 AS VLR_COMISSAO,
            0 AS VLR_COMISSAO_FABRIC,
            ISNULL(VF.CD_FUN,PDV_CUPOM_NAO_FISCAL.CD_USU) AS CD_FUN,
            PDV_CUPOM_NAO_FISCAL.CD_USU,
			0 AS VLR_RECOMPOSICAO_MARGEM,
			0 AS VLR_CONV_PBM,
			5 AS ORIG_VENDA,
			0 AS VLR_ISSQN 
			,0 		as CD_PARCEIRO 
			,'' 	as CPF_CLIENTE_PARCEIRO
			,'' 	as NOME_CLIENTE_PARCEIRO
			,0 		as TIPO_DESCONTO
			,''  	as DS_TP_DESCONTO
    FROM PDV_CUPOM_NAO_FISCAL
            INNER JOIN GLB_DT_MOVIMENTO ON PDV_CUPOM_NAO_FISCAL.DT_CUPOM = GLB_DT_MOVIMENTO.DT_MOVIMENTO
        --    LEFT OUTER JOIN GLB_OPER_CEL_CPL ON PDV_CUPOM_NAO_FISCAL.CD_OPER_CEL = GLB_OPER_CEL_CPL.NR_OPER_CEL
			LEFT OUTER JOIN GLB_OPER_CEL_CPL ON SUBSTRING ( PDV_CUPOM_NAO_FISCAL.CD_OPER_CEL ,0 , len(GLB_OPER_CEL_CPL.NR_OPER_CEL)+1) = GLB_OPER_CEL_CPL.NR_OPER_CEL

            LEFT OUTER JOIN GLB_OPER_CEL ON GLB_OPER_CEL_CPL.CD_EMP = GLB_OPER_CEL.CD_EMP
                                        AND GLB_OPER_CEL_CPL.CD_OPER_CEL = GLB_OPER_CEL.CD_OPER_CEL
			LEFT JOIN FP_FUNC VF ON PDV_CUPOM_NAO_FISCAL.CD_EMP = VF.CD_EMP
										   --AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = VF.CD_FILIAL
										   AND PDV_CUPOM_NAO_FISCAL.CD_USU = VF.CD_FUNC_USU
    WHERE PDV_CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 3
            AND PDV_CUPOM_NAO_FISCAL.CD_EMP = @CD_EMP
            AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM = @DT_PROC
			AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL =@CD_FILIAL
			AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0;

/**********************************************************************************************************************************************/
--Vendas devolvidas
/**********************************************************************************************************************************************/
     INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasItens (CD_EMP,      CD_FILIAL,      CD_VD,      CD_PROD,      CD_CTR_DT_MOVIMENTO,      TIPO_VENDA,      VLR_VD,
		VLR_DESC_ITENS,      VLR_VD_LIQ,      QTDE_VENDAS,      QT_ITENS,      VLR_DESC_VERBA,      VLR_DESC_RATEIO,      VLR_PMC,
		VLR_DESC_OFERTA,      VLR_CUSTO,      VLR_CUSTO_MEDIO,      VLR_CUSTO_GER,      VLR_ICMS,      VLR_PIS_COFINS,      QTDE_ITENS,
		VLR_DINHEIRO,      VLR_CHEQUES,      VLR_CHEQUES_VISTA,      VLR_CHEQUES_PRAZO,      VLR_CARTAO,      VLR_TICKETS,
		VLR_DUPLICATA,      VLR_CONV,      VLR_CHEQUE_TROCO,      VLR_NCC,      VLR_COMISSAO,      VLR_COMISSAO_FABRIC, CD_VEND, 
		CD_OPERADOR,VLR_RECOMPOSICAO_MARGEM, VLR_CONV_PBM,CD_ORIGEM_VENDA,VLR_ISSQN, CD_PARCEIRO,CPF_CLIENTE_PARCEIRO,NOME_CLIENTE_PARCEIRO,TIPO_DESCONTO,DS_TIPO_DESCONTO)

            SELECT PDV_VD_DEV_EST_PROD_IMP.CD_EMP,
                   PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL,
                   PDV_VD_DEV_EST_PROD_IMP.CD_VD,
                   PDV_VD_DEV_EST_PROD_IMP.CD_PROD,
                   GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO,
                   3 AS TIPO_VENDA,
                   (PDV_VD_DEV_EST_PROD_IMP.VLR_IT_BRUTO * PDV_VD_DEV_EST_PROD_IMP.QT_IT)*-1 AS VLR_VD,
                   (((PDV_VD_DEV_EST_PROD_IMP.VLR_DESC_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT)) - PDV_VD_DEV_EST_PROD_IMP.VLR_DESC_VERBA)*-1 AS VLR_DESC_ITENS,
                   (PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT)*-1 AS VLR_LIQ_VD,
                   0 AS QTDE_VENDAS,
                   PDV_VD_DEV_EST_PROD_IMP.QT_IT *-1 AS QT_IT,
                   ISNULL(PDV_VD_DEV_EST_PROD_IMP.VLR_DESC_VERBA, 0)*-1 AS VLR_DESC_VERBA,
                   0 AS VLR_DESC_TOT_RAT,
                   (ISNULL(PDV_VD_DEV_EST_PROD_IMP.VLR_PMC_IT, 0) * PDV_VD_DEV_EST_PROD_IMP.QT_IT)*-1 AS VLR_PMC,
                   ((PDV_VD_DEV_EST_PROD_IMP.VLR_PMC_IT - PDV_VD_DEV_EST_PROD_IMP.VLR_IT_BRUTO) * PDV_VD_DEV_EST_PROD_IMP.QT_IT)*-1 AS VLR_DESC_OFERTA,
                   (PDV_VD_DEV_EST_PROD_IMP.QT_IT * ISNULL(PDV_VD_DEV_EST_PROD_IMP.VLR_CUSTO, 0))*-1 AS VLR_CUSTO,
                   (PDV_VD_DEV_EST_PROD_IMP.QT_IT * ISNULL(PDV_VD_DEV_EST_PROD_IMP.VLR_CUSTO_MEDIO, 0))*-1 AS VLR_CUSTO_MEDIO,
                   (PDV_VD_DEV_EST_PROD_IMP.QT_IT * ISNULL(PDV_VD_DEV_EST_PROD_IMP.VLR_CUSTO_MEDIO, 0))*-1 AS VLR_CUSTO_GER,
                   (ENT_IT.VLR_ICMS_IT)* -1 													AS VLR_ICMS,
                   (PDV_VD_DEV_EST_PROD_IMP.VLR_PIS + PDV_VD_DEV_EST_PROD_IMP.VLR_COFINS) * -1  AS VLR_PIS_COFINS,
                   PDV_VD_DEV_EST_PROD_IMP.QT_IT *-1,
                   (PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT)*-1 AS VLR_DINHEIRO,
                   0 AS VLR_CHEQUES ,
                   0 AS VLR_CHEQUES_VISTA,
                   0  AS VLR_CHEQUES_PRAZO,
                   0  AS VLR_CARTAO,
                   0  AS VLR_TICKETS,
                   0  AS VLR_DUPLICATA,
                   0  AS VLR_CONV,
                   0  AS VLR_CHEQUE_TROCO,
                   0  AS VLR_NCC,
                   (((PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * PDV_VD_DEV_EST_PROD_IMP.PERC_COMIS) / 100)*-1 AS VLR_COMISSAO,
                   ISNULL(PDV_VD_DEV_EST_PROD_IMP.VLR_COMISSAO_FABRIC, 0)*-1,
                   PDV_VD_DEV_EST_PROD_IMP.CD_VEND,
                   PDV_VD.CD_USU,
				   0  AS VLR_RECOMPOSICAO_MARGEM,
				   0  AS VLR_CONV_PBM,
				   6  AS ORIG_VENDA,
				   0  AS VLR_ISSQN
				   ,0 		as CD_PARCEIRO 
				   ,'' 		as CPF_CLIENTE_PARCEIRO
				   ,'' 		as NOME_CLIENTE_PARCEIRO
				   ,0 		as TIPO_DESCONTO
				   ,''  	as DS_TP_DESCONTO
            FROM PDV_VD_DEV_EST_PROD_IMP
                 INNER JOIN PDV_VD ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD.CD_EMP
                                      AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD.CD_FILIAL
                                      AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD.CD_VD
				 INNER JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT  ENT ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP    = ENT.CD_EMP
                                     AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = ENT.CD_FILIAL
                                     AND PDV_VD_DEV_EST_PROD_IMP.CD_VD     = ENT.CD_VD	
									 AND PDV_VD_DEV_EST_PROD_IMP.CD_IMP    = ENT.CD_IMP
									 AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD   = ENT.CD_PROD 
				 INNER JOIN EST_NF_ENT_IT ENT_IT ON ENT_IT.CD_EMP 	   = ENT.CD_EMP 	
												AND ENT_IT.CD_FILIAL   = ENT.CD_FILIAL	
                                                AND ENT_IT.CD_NF	   = ENT.CD_NF	
                                                AND ENT_IT.CD_PROD     = ENT.CD_PROD 
									 
                 INNER JOIN GLB_DT_MOVIMENTO ON PDV_VD_DEV_EST_PROD_IMP.DT_DEVO = GLB_DT_MOVIMENTO.DT_MOVIMENTO
                 INNER JOIN EST_PROD_CPL ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD_CPL.CD_EMP
                                            AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
                                            AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD_CPL.CD_PROD
            WHERE PDV_VD_DEV_EST_PROD_IMP.CD_EMP = @CD_EMP
                  AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO = @DT_PROC
				  AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL =@CD_FILIAL;

/**********************************************************************************************************************************************/
	if @PrintDebug > 0
		PRINT 'Vendas notas fiscais - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
/**********************************************************************************************************************************************/
-- Tag #A002  
	 --Vendas nota fiscal
     INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasItens
		 (CD_EMP,      CD_FILIAL,      CD_VD,      CD_PROD,      CD_CTR_DT_MOVIMENTO,      TIPO_VENDA,      VLR_VD,     VLR_DESC_ITENS,
		  VLR_VD_LIQ,      QTDE_VENDAS,      QT_ITENS,      VLR_DESC_VERBA,      VLR_DESC_RATEIO,      VLR_PMC,      VLR_DESC_OFERTA,      VLR_CUSTO,
		  VLR_CUSTO_MEDIO,      VLR_CUSTO_GER,      VLR_ICMS,      VLR_PIS_COFINS,      QTDE_ITENS,      VLR_DINHEIRO,      VLR_CHEQUES,
		  VLR_CHEQUES_VISTA,      VLR_CHEQUES_PRAZO,      VLR_CARTAO,      VLR_TICKETS,      VLR_DUPLICATA,      VLR_CONV,
		  VLR_CHEQUE_TROCO,      VLR_NCC,   VLR_COMISSAO,      VLR_COMISSAO_FABRIC,   CD_VEND,      CD_OPERADOR,VLR_RECOMPOSICAO_MARGEM, VLR_CONV_PBM,CD_ORIGEM_VENDA,VLR_ISSQN
		  , CD_PARCEIRO,CPF_CLIENTE_PARCEIRO,NOME_CLIENTE_PARCEIRO,TIPO_DESCONTO,DS_TIPO_DESCONTO)
        SELECT
			   EST_NF_SAI_IT.CD_EMP
			 , EST_NF_SAI_IT.CD_FILIAL
			 , EST_NF_SAI_IT.CD_NF
			 , EST_NF_SAI_IT.CD_PROD
			 , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
			 , 10 AS TIPO_VENDA
			 , VLR_TOT_IT AS VLR_VD
			 , (EST_NF_SAI_IT.VLR_DESC_IT) AS VLR_DESC_ITENS
			 , (((EST_NF_SAI_IT.VLR_TOT_IT  + ISNULL(EST_NF_SAI_IT.VLR_PROD_FRETE,0) )- EST_NF_SAI_IT.VLR_DESC_IT)) AS VLR_LIQ_VD
			 , 0 AS QTDE_VENDAS
			 , EST_NF_SAI_IT.QT_IT AS QT_IT
			 , 0 AS VLR_DESC_VERBA
			 , 0 AS VLR_DESC_TOT_RAT
			 , EST_NF_SAI_IT.VLR_TOT_IT AS VLR_PMC
			 , 0 AS VLR_DESC_OFERTA
			
			, CASE WHEN EST_PROD_CPL.TP_PROD IN(10, 11) 
					THEN EST_NF_SAI_IT.VLR_TOT_IT - (EST_NF_SAI_IT.VLR_TOT_IT * (EST_PROD_CPL.PERC_COMISSAO_SERVICO / 100))
					ELSE EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_CUSTO_MD
                 END VLR_CUSTO
			 , CASE WHEN EST_PROD_CPL.TP_PROD IN(10, 11) 
					THEN EST_NF_SAI_IT.VLR_TOT_IT - (EST_NF_SAI_IT.VLR_TOT_IT * (EST_PROD_CPL.PERC_COMISSAO_SERVICO / 100))
					ELSE EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_CUSTO_MD
                 END VLR_CUSTO_MEDIO
			 , CASE WHEN EST_PROD_CPL.TP_PROD IN(10, 11) 
					THEN EST_NF_SAI_IT.VLR_TOT_IT - (EST_NF_SAI_IT.VLR_TOT_IT * (EST_PROD_CPL.PERC_COMISSAO_SERVICO / 100))
					ELSE EST_NF_SAI_IT.QT_IT * EST_NF_SAI_IT.VLR_CUSTO_MD
                 END VLR_CUSTO_GER
			 --, (EST_NF_SAI_IT.QT_IT * ISNULL(EST_NF_SAI_IT.VLR_CUSTO_MD, 0)) AS VLR_CUSTO
			 --, (EST_NF_SAI_IT.QT_IT * ISNULL(EST_NF_SAI_IT.VLR_CUSTO_MD, 0)) AS VLR_CUSTO_MEDIO
			 --, (EST_NF_SAI_IT.QT_IT * ISNULL(EST_NF_SAI_IT.VLR_CUSTO_MD, 0)) AS VLR_CUSTO_GER
			 , EST_NF_SAI_IT.VLR_ICMS_IT
			 , (ROUND(EST_NF_SAI_IT.VLR_PIS ,2) + ROUND(EST_NF_SAI_IT.VLR_COFINS,2))
			 , EST_NF_SAI_IT.QT_IT
			 , 0 AS VLR_DINHEIRO
			 , 0 AS VLR_CHEQUES
			 , 0 AS VLR_CHEQUES_VISTA
			 , 0 AS VLR_CHEQUES_PRAZO
			 , 0 AS VLR_CARTAO
			 , 0 AS VLR_TICKETS
			 , ((EST_NF_SAI_IT.VLR_TOT_IT - EST_NF_SAI_IT.VLR_DESC_IT)) AS VLR_DUPLICATA
			 , 0 AS VLR_CONV
			 , 0 AS VLR_CHEQUE_TROCO
			 , 0 AS VLR_NCC
			 , (((EST_NF_SAI_IT.VLR_TOT_IT - EST_NF_SAI_IT.VLR_DESC_IT) * EST_NF_SAI_IT.PERC_COMI) / 100) AS VLR_COMISSAO
			 , 0 AS VLR_COMISSAO_FABRIC
			 , EST_NF_SAI.CD_VEND
			 , EST_NF_SAI.CD_USU
			 , 0 AS VLR_RECOMPOSICAO_MARGEM
			 , 0 AS VLR_CONV_PBM
			 , 7 AS ORIG_VENDA
			 , 0 AS VLR_ISSQN
			 , 0 		as CD_PARCEIRO 
			 , '' 		as CPF_CLIENTE_PARCEIRO
			 , '' 		as NOME_CLIENTE_PARCEIRO
			 , 0 		as TIPO_DESCONTO
			 , ''  		as DS_TP_DESCONTO
		FROM
			 EST_NF_SAI_IT
			 INNER JOIN GLB_DT_MOVIMENTO ON EST_NF_SAI_IT.DT_EMI_NF = GLB_DT_MOVIMENTO.DT_MOVIMENTO
			 INNER JOIN EST_NF_SAI ON EST_NF_SAI_IT.CD_EMP = EST_NF_SAI.CD_EMP
									  AND EST_NF_SAI_IT.CD_FILIAL = EST_NF_SAI.CD_FILIAL
									  AND EST_NF_SAI_IT.CD_NF = EST_NF_SAI.CD_NF
									  AND EST_NF_SAI_IT.DT_EMI_NF = EST_NF_SAI.DT_EMI_NF
			 INNER JOIN EST_NF_SAI_VENDAS ON EST_NF_SAI.CD_EMP = EST_NF_SAI_VENDAS.CD_EMP
											 AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_VENDAS.CD_FILIAL
											 AND EST_NF_SAI.CD_NF = EST_NF_SAI_VENDAS.CD_NF
			 INNER JOIN EST_PROD_CPL ON EST_NF_SAI_IT.CD_EMP    = EST_PROD_CPL.CD_EMP
                                    AND EST_NF_SAI_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
                                    AND EST_NF_SAI_IT.CD_PROD   = EST_PROD_CPL.CD_PROD
		WHERE EST_NF_SAI.CD_EMP = @CD_EMP
			  AND EST_NF_SAI.DT_EMI_NF = @DT_PROC
			  AND EST_NF_SAI.STS_NF = 0
			  AND EST_NF_SAI.CD_FILIAL = @CD_FILIAL;
/**********************************************************************************************************************************************/
	if @PrintDebug > 0
     PRINT 'Devolucao de vendas em notas fiscais - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
/**********************************************************************************************************************************************/
/**********************************************************************************************************************************************/
--Vendas devolvidas nota fiscal
/**********************************************************************************************************************************************/
-- Tag #A001 
	INSERT INTO EST_MOVIMENTO_VENDAS_RsVendasItens (CD_EMP,      CD_FILIAL,      CD_VD,      CD_PROD,      CD_CTR_DT_MOVIMENTO,      TIPO_VENDA,      VLR_VD,
		VLR_DESC_ITENS,      VLR_VD_LIQ,      QTDE_VENDAS,      QT_ITENS,      VLR_DESC_VERBA,      VLR_DESC_RATEIO,      VLR_PMC,
		VLR_DESC_OFERTA,      VLR_CUSTO,      VLR_CUSTO_MEDIO,      VLR_CUSTO_GER,      VLR_ICMS,      VLR_PIS_COFINS,      QTDE_ITENS,
		VLR_DINHEIRO,      VLR_CHEQUES,      VLR_CHEQUES_VISTA,      VLR_CHEQUES_PRAZO,      VLR_CARTAO,      VLR_TICKETS,
		VLR_DUPLICATA,      VLR_CONV,      VLR_CHEQUE_TROCO,      VLR_NCC,      VLR_COMISSAO,      VLR_COMISSAO_FABRIC, CD_VEND, 
		CD_OPERADOR,VLR_RECOMPOSICAO_MARGEM, VLR_CONV_PBM,CD_ORIGEM_VENDA,VLR_ISSQN, CD_PARCEIRO,CPF_CLIENTE_PARCEIRO,NOME_CLIENTE_PARCEIRO,TIPO_DESCONTO,DS_TIPO_DESCONTO)

				SELECT
			   V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_NF
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_PROD
			 , GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
			 , 11 AS TIPO_VENDA
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_IT_BRUTO * -1 AS VLR_VD
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_DESC_IT * -1 AS VLR_DESC_ITENS
			-- , V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_IT_DEV_LIQ * -1 AS VLR_LIQ_VD
			 ,(V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_IT_DEV_LIQ * V_EST_NF_SAI_VENDAS_DEVOLUCAO.QT_IT ) * -1 AS VLR_LIQ_VD
			 , 0 AS QTDE_VENDAS
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.QT_IT * -1 AS QT_IT
			 , 0 * -1 AS VLR_DESC_VERBA
			 , 0 AS VLR_DESC_TOT_RAT
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_IT_BRUTO * -1 AS VLR_PMC
			 , 0 AS VLR_DESC_OFERTA
			 , (V_EST_NF_SAI_VENDAS_DEVOLUCAO.QT_IT * ISNULL(V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_CUSTO, 0)) * -1 AS VLR_CUSTO
			 , (V_EST_NF_SAI_VENDAS_DEVOLUCAO.QT_IT * ISNULL(V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_CUSTO_MEDIO, 0)) * -1 AS VLR_CUSTO_MEDIO
			 , (V_EST_NF_SAI_VENDAS_DEVOLUCAO.QT_IT * ISNULL(V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_CUSTO_MEDIO, 0)) * -1 AS VLR_CUSTO_GER
			 , (V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_ICMS_IT) * - 1															AS VLR_ICMS 
			 , (ROUND(V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_PIS ,2) + ROUND(V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_COFINS,2)) *-1	AS VLR_PIS_COFINS 
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.QT_IT * -1
			 , 0 AS VLR_DINHEIRO
			 , 0 AS VLR_CHEQUES
			 , 0 AS VLR_CHEQUES_VISTA
			 , 0 AS VLR_CHEQUES_PRAZO
			 , 0 AS VLR_CARTAO
			 , 0 AS VLR_TICKETS
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_TOT_IT * -1 AS VLR_DUPLICATA
			 , 0 AS VLR_CONV
			 , 0 AS VLR_CHEQUE_TROCO
			 , 0 AS VLR_NCC
			 , (V_EST_NF_SAI_VENDAS_DEVOLUCAO.VLR_TOT_IT) * (V_EST_NF_SAI_VENDAS_DEVOLUCAO.PERC_COMI / 100) * -1 AS VLR_COMISSAO
			 , 0
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_VEND
			 , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_USU
			 , 0 AS VLR_RECOMPOSICAO_MARGEM
			 , 0 AS VLR_CONV_PBM
			 , 8 AS ORIG_VENDA
			 , 0 AS VLR_ISSQN
			 ,0 		as CD_PARCEIRO 
			 ,'' 		as CPF_CLIENTE_PARCEIRO
			 ,'' 		as NOME_CLIENTE_PARCEIRO
			 ,0 		as TIPO_DESCONTO
			 ,''  		as DS_TP_DESCONTO
		FROM
			 V_EST_NF_SAI_VENDAS_DEVOLUCAO
			 INNER JOIN GLB_DT_MOVIMENTO ON V_EST_NF_SAI_VENDAS_DEVOLUCAO.DT_DEVO = GLB_DT_MOVIMENTO.DT_MOVIMENTO
		WHERE V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP = @CD_EMP
			  AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.DT_DEVO = @DT_PROC
			  AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL = @CD_FILIAL;
  
		FETCH NEXT FROM cLojsFl INTO @CD_FILIAL
	end

     CLOSE cLojsFl;
	DEALLOCATE cLojsFl; 
/**********************************************************************************************************************************************/
	if @PrintDebug > 0
     PRINT 'update qtde vendas itens - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
/**********************************************************************************************************************************************/
     
	UPDATE I
       SET
           i.QTDE_VENDAS = d.QTDE_VENDAS
     FROM EST_MOVIMENTO_VENDAS_RsVendasItens i
          INNER JOIN EST_MOVIMENTO_VENDAS_RsVendasQtde d ON i.CD_EMP = d.CD_EMP
                                        AND i.CD_FILIAL = d.CD_FILIAL
                                        AND i.CD_CTR_DT_MOVIMENTO = d.CD_CTR_DT_MOVIMENTO
                                        AND i.TIPO_VENDA = d.TIPO_VENDA
	where 
		I.CD_CTR_DT_MOVIMENTO= @CD_CTR_DT_MOVIMENTO
		AND I.CD_FILIAL = @CD_FILIAL_PARAM
		AND I.CD_EMP=1	;

    if @PrintDebug > 0
		 PRINT 'Gravando vendas do dia - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);     
/**********************************************************************************************************************************************/
    INSERT INTO EST_MOVIMENTO_VENDAS (CD_CTR_DT_MOVIMENTO,      CD_EMP,      CD_FILIAL,      QTDE_VD,      TIPO_VENDA, DT_PROC)
    SELECT 
	   v.CD_CTR_DT_MOVIMENTO,
	   v.CD_EMP,
	   v.CD_FILIAL,
	   v.QTDE_VENDAS AS QT_VD,
	   v.TIPO_VENDA,
	   GETDATE()
    FROM EST_MOVIMENTO_VENDAS_RsVendasQtde v
	where 
			V.CD_CTR_DT_MOVIMENTO= @CD_CTR_DT_MOVIMENTO
		AND V.CD_FILIAL = @CD_FILIAL_PARAM
		AND V.CD_EMP=1
/**********************************************************************************************************************************************/
	if @PrintDebug > 0
		PRINT 'Gravando dados de vendas do itens para analise em relatorios - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
/**********************************************************************************************************************************************/
 

     INSERT INTO EST_MOVIMENTO_VENDAS_PRODUTOS (CD_CTR_VENDAS,      CD_EMP,      CD_PROD,      VLR_VD,      VLR_DESC_ITENS,      VLR_VD_LIQ,
														  VLR_PMC,      VLR_CUSTO_MD,      VLR_CUSTO_GER,      VLR_CUSTO,      VLR_DESC_OFERTA,      VLR_DESC_VERBA,
														  VLR_DESC_RATEIO,      VLR_ICMS,      VLR_PIS_COFINS,      QTDE_ITENS,      VLR_DINHEIRO,      VLR_CHEQUES,      VLR_CHEQUES_VISTA,
														  VLR_CHEQUES_PRAZO,      VLR_CARTAO,      VLR_TICKETS,      VLR_DUPLICATA,      VLR_CONV,      VLR_CHEQUE_TROCO,      VLR_NCC,
														  QTDE_VD,      CD_VEND,      CD_OPERADOR,      VLR_COMISSAO_FABRIC,      VLR_COMISSAO,	  VLR_RECOMPOSICAO_MARGEM,	  VLR_CONV_PBM,	  CD_ORIGEM_VENDA,	  VLR_ISSQN
														  , CD_PARCEIRO , CPF_CLIENTE_PARCEIRO ,NOME_CLIENTE_PARCEIRO,TIPO_DESCONTO ,DS_TIPO_DESCONTO )
	SELECT
		EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
		, i.CD_EMP
		, i.CD_PROD
		, SUM(i.VLR_VD) AS VLR_VD
		, SUM(i.VLR_DESC_ITENS) AS VLR_DESC_ITENS
		, SUM(i.VLR_VD_LIQ) AS VLR_VD_LIQ
		, SUM(i.VLR_PMC) AS VLR_PMC
		, ISNULL(SUM(i.VLR_CUSTO_MEDIO), 0) AS VLR_CUSTO_MEDIO
		, ISNULL(SUM(i.VLR_CUSTO_GER), 0) AS VLR_CUSTO_GER
		, ISNULL(SUM(i.VLR_CUSTO), 0) AS VLR_CUSTO
		, ISNULL(SUM(i.VLR_DESC_OFERTA), 0) AS VLR_DESC_OFERTA
		, SUM(i.VLR_DESC_VERBA) AS VLR_DESC_VERBA
		, SUM(i.VLR_DESC_RATEIO) AS VLR_DESC_RATEIO
		, COALESCE(SUM(VLR_ICMS), 0) AS VLR_ICMS
		, ISNULL(SUM(VLR_PIS_COFINS), 0) AS VLR_PIS_COFINS
		, SUM(I.QTDE_ITENS) AS QTDE_ITENS
		, SUM(VLR_DINHEIRO)
		, SUM(VLR_CHEQUES)
		, SUM(VLR_CHEQUES_VISTA)
		, SUM(VLR_CHEQUES_PRAZO)
		, SUM(VLR_CARTAO)
		, SUM(VLR_TICKETS)
		, SUM(VLR_DUPLICATA)
		, SUM(VLR_CONV)
		, SUM(VLR_CHEQUE_TROCO)
		, SUM(VLR_NCC)
		, COUNT(DISTINCT i.CD_VD)
		, i.CD_VEND
		, COALESCE(i.CD_OPERADOR, 0)
		, SUM(VLR_COMISSAO_FABRIC)
		, SUM(VLR_COMISSAO)
		, SUM(VLR_RECOMPOSICAO_MARGEM)
		, SUM(VLR_CONV_PBM)
		, CD_ORIGEM_VENDA
		, SUM(VLR_ISSQN)
		,ISNULL(i.CD_PARCEIRO,0) 		     
		,ISNULL(i.CPF_CLIENTE_PARCEIRO,'') 
		,ISNULL(i.NOME_CLIENTE_PARCEIRO,'')
		,ISNULL(i.TIPO_DESCONTO,0)
		,ISNULL(i.DS_TIPO_DESCONTO,'') 
	FROM
			EST_MOVIMENTO_VENDAS_RsVendasItens i
			INNER JOIN EST_MOVIMENTO_VENDAS ON i.CD_CTR_DT_MOVIMENTO = EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO
											AND i.CD_EMP = EST_MOVIMENTO_VENDAS.CD_EMP
											AND i.CD_FILIAL = EST_MOVIMENTO_VENDAS.CD_FILIAL
											AND i.TIPO_VENDA = EST_MOVIMENTO_VENDAS.TIPO_VENDA
	WHERE I.CD_CTR_DT_MOVIMENTO = @CD_CTR_DT_MOVIMENTO
			AND I.CD_EMP = 1
			AND I.CD_FILIAL = @CD_FILIAL_PARAM
	GROUP BY
					i.CD_EMP
			, EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
			, i.TIPO_VENDA
			, i.CD_PROD
			, i.CD_VEND
			, i.CD_OPERADOR
			, i.CD_ORIGEM_VENDA
			, i.CD_PARCEIRO
			, i.CPF_CLIENTE_PARCEIRO
			, i.NOME_CLIENTE_PARCEIRO
			, i.TIPO_DESCONTO
			, i.DS_TIPO_DESCONTO;

/**********************************************************************************************************************************************/
	print '======================================================FIM MOVIMENTO DE VENDAS ===================================================='
	print ''
	 
	EXEC P_EST_MOVIMENTO_VENDAS_TICKETS 	@CD_EMP	, @DT_PROC, @CD_FILIAL_PARAM, @PrintDebug;	
	print ''

	